function probabilite=normalisation(sys,E,rho,pas)
%   NORMALISATION permet de vrifier que la densit linique de probabilit
%   est bien normalise  1. 
%   NORMALISATION(sys,E,rho,pas)
%       >> sys = Systme {Objet physique - Energie potentielle}
%       >> E = Valeurs des nergies de l'objet physique
%       >> rho = Densit linique de probabilit
%       >> pas = Pas d'intgration
%       << probabilit (qui doit tre proche de 1)
%
% Olivier Pujol : septembre 2013
%
if length(E)>=2
    En=input('Valeur de l''nergie ( choisir) :');
    Ep=nan(1,length(sys{1}));
    Ep(1)=sys{1}{1}(1);
    for ic=2:length(sys{1})
        Ep(ic)=get(sys{1}{ic},'EnergiePotentielleSortie');
    end
    En=min(Ep)+En;    
    iE=find(abs(En-E)==min(abs(En-E))); % On repre l'indice correspondant (valeur la plus proche entre En et E)
end
if (length(E)==1),iE=1;end

probabilite=0;
for iz=1:length(sys{iE})
probabilite = probabilite+0.5*sum((rho{iz}(1:end-1)+rho{iz}(2:end))*pas);
end

return;